/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class DamageableMeltingRecipe
extends MeltingRecipe {
    private static final int[] EMPTY_SIZE = new int[0];
    private final int unitSize;
    private final int[] byproductSizes;

    public DamageableMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, int unitSize, int ... byproductSizes) {
        super(id, group, input, output, temperature, time, byproducts);
        this.unitSize = unitSize;
        this.byproductSizes = byproductSizes;
    }

    private static FluidStack scaleOutput(FluidStack fluid, int damage, int maxDamage, int unitSize) {
        int remainder;
        int amount = fluid.getAmount() * (maxDamage - damage) / maxDamage;
        if (amount <= unitSize) {
            amount = Math.max(unitSize, 1);
        } else if (unitSize > 1 && (remainder = amount % unitSize) > 0) {
            amount -= remainder;
        }
        return new FluidStack(fluid, amount);
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        FluidStack output = this.getOutput();
        ItemStack input = inv.getStack();
        int maxDamage = input.m_41776_();
        if (maxDamage <= 0) {
            return output.copy();
        }
        return DamageableMeltingRecipe.scaleOutput(output, input.m_41773_(), maxDamage, this.unitSize);
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, IFluidHandler handler) {
        ItemStack input = inv.getStack();
        int maxDamage = input.m_41776_();
        if (maxDamage <= 0) {
            super.handleByproducts(inv, handler);
        } else {
            int itemDamage = input.m_41773_();
            for (int i = 0; i < this.byproducts.size(); ++i) {
                FluidStack fluidStack = (FluidStack)this.byproducts.get(i);
                handler.fill(DamageableMeltingRecipe.scaleOutput(fluidStack, itemDamage, maxDamage, i < this.byproductSizes.length ? this.byproductSizes[i] : this.unitSize), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.damagableMeltingSerializer.get();
    }

    public static class Serializer
    extends MeltingRecipe.AbstractSerializer<DamageableMeltingRecipe> {
        @Override
        protected DamageableMeltingRecipe createFromJson(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, JsonObject json) {
            int unitSize = GsonHelper.m_13824_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (String)"unit_size", (int)1);
            int[] byproductSizes = EMPTY_SIZE;
            if (json.has("byproducts")) {
                byproductSizes = StreamSupport.stream(GsonHelper.m_13933_((JsonObject)json, (String)"byproducts").spliterator(), false).mapToInt(element -> GsonHelper.m_13824_((JsonObject)element.getAsJsonObject(), (String)"unit_size", (int)1)).toArray();
            }
            return new DamageableMeltingRecipe(id, group, input, output, temperature, time, byproducts, unitSize, byproductSizes);
        }

        @Override
        protected DamageableMeltingRecipe createFromNetwork(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, FriendlyByteBuf buffer) {
            int unitSize = buffer.m_130242_();
            int[] byproductSizes = buffer.m_130100_();
            return new DamageableMeltingRecipe(id, group, input, output, temperature, time, byproducts, unitSize, byproductSizes);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, DamageableMeltingRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.m_130130_(recipe.unitSize);
            buffer.m_130089_(recipe.byproductSizes);
        }
    }
}

